/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.jar;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.jar.Attributes;
import net.neoforged.neoforgespi.locating.IModFile;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.fixes.SimpleTypeAdapter;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.util.provider.ClassLookup;
import org.sinytra.connector.transformer.jar.JarTransformer;
import org.sinytra.connector.util.ConnectorUtil;

public class BytecodeFixerUpperFrontend {
    private static final List<TypeAdapter> FIELD_TYPE_ADAPTERS = List.of(new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/core/Holder$Reference"), Type.getObjectType((String)"java/lang/Object"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/core/Holder$Reference", "value", "()Ljava/lang/Object;"))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/resources/ResourceLocation"), Type.getObjectType((String)"java/lang/String"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/resources/ResourceLocation", "toString", "()Ljava/lang/String;"))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/world/item/ItemStack"), Type.getObjectType((String)"net/minecraft/world/item/Item"), (list, insn) -> list.insert(insn, (AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/world/item/ItemStack", "getItem", "()Lnet/minecraft/world/item/Item;"))), new SimpleTypeAdapter(Type.getObjectType((String)"net/minecraft/world/entity/Mob"), Type.getObjectType((String)"net/minecraft/world/entity/monster/Monster"), (list, insn) -> {}));
    private final BytecodeFixerUpper bfu;
    private final ConnectorUtil.CacheFile cacheFile;

    public BytecodeFixerUpperFrontend(ClassLookup cleanLookup, ClassLookup dirtyLookup) {
        this.bfu = new BytecodeFixerUpper(cleanLookup, dirtyLookup, FIELD_TYPE_ADAPTERS);
        Path path = JarTransformer.getGeneratedJarPath();
        this.cacheFile = ConnectorUtil.getCached(null, path);
        if (this.cacheFile.isUpToDate()) {
            this.bfu.getGenerator().loadExisting(path);
        }
    }

    public BytecodeFixerUpper unwrap() {
        return this.bfu;
    }

    public void saveGeneratedAdapterJar() throws IOException {
        Path path = JarTransformer.getGeneratedJarPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(path);
        Attributes attributes = new Attributes();
        attributes.putValue("FMLModType", IModFile.Type.GAMELIBRARY.name());
        if (this.bfu.getGenerator().save(path, attributes)) {
            this.cacheFile.save();
        }
    }
}

